<?php require_once "koneksi.php"; ?>
<!DOCTYPE html>
<html>
<head>
    <title>Transaksi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">
<h4>Transaksi</h4>

<form method="POST" action="simpan_transaksi.php" class="row g-2 mb-3">
    <div class="col-md-3">
        <input type="date" name="tanggal" class="form-control" required>
    </div>

    <div class="col-md-3">
        <select name="barang" id="barang" class="form-control" onchange="setHarga(this.value)" required>
            <option value="">Pilih Barang</option>
            <?php
            $b = mysqli_query($koneksi,"SELECT * FROM barang");
            while($br=mysqli_fetch_array($b)){
                echo "<option value='$br[id_barang]|$br[nama_barang]|$br[harga]'>
                        $br[nama_barang]
                      </option>";
            }
            ?>
        </select>
    </div>

    <div class="col-md-2">
        <input type="number" id="harga" name="harga" class="form-control" placeholder="Harga" readonly>
    </div>

    <div class="col-md-2">
        <input type="number" name="jumlah" id="jumlah" class="form-control" placeholder="Jumlah" required>
    </div>

    <div class="col-md-2">
        <input type="number" id="total" name="total" class="form-control" placeholder="Total" readonly>
    </div>

    <div class="col-md-12">
        <button class="btn btn-primary w-100">Simpan</button>
    </div>
</form>

<table class="table table-bordered table-striped">
<tr>
    <th>No</th>
    <th>Tanggal</th>
    <th>Barang</th>
    <th>Harga</th>
    <th>Jumlah</th>
    <th>Total</th>
    <th>Aksi</th>
</tr>

<?php
$no=1;
$data = mysqli_query($koneksi,"SELECT * FROM transaksi");
while($d=mysqli_fetch_array($data)){
?>
<tr>
<td><?= $no++ ?></td>
<td><?= $d['tanggal'] ?></td>
<td><?= $d['nama_barang'] ?></td>
<td><?= number_format($d['harga']) ?></td>
<td><?= $d['jumlah'] ?></td>
<td><?= number_format($d['total']) ?></td>
<td>
    <a href="cetak.php?id=<?= $d['id_transaksi'] ?>" target="_blank" class="btn btn-success btn-sm">Cetak</a>
    <a href="hapus_transaksi.php?id=<?= $d['id_transaksi'] ?>" class="btn btn-danger btn-sm">Hapus</a>
</td>
</tr>
<?php } ?>
</table>

<a href="index.php" class="btn btn-secondary">Kembali</a>
</div>

<script>
function setHarga(val){
    let data = val.split("|");
    document.getElementById("harga").value = data[2]; // harga
}

document.getElementById("jumlah").addEventListener("keyup", function(){
    let harga = document.getElementById("harga").value;
    let jumlah = this.value;
    document.getElementById("total").value = harga * jumlah;
});
</script>

</body>
</html>
